# Tracked PostHog Events

This reference lists every PostHog event currently emitted by MiBa Video Manager. Keep it updated whenever new events are added or existing ones are removed/renamed. Events are filtered by the runtime registry (`config/posthog-events.json` + remote overrides), so adding a new event requires updating that file as well.

- **Renderer events** originate from `renderer/scripts/main.js` via `trackEvent`. Each event automatically includes base properties from `getBaseAnalyticsProps` (`view_mode`, `total_videos`, `monitored_directory_count`, `youtube_connected`) along with event-specific fields noted below.
- **Main process events** are sent from `main.js` with `analytics.captureMainEvent`.
- **Transcoder events** are queued from `server/index.js` with `trackTranscoderEvent` and always include `active_session_count`.

## Renderer (UI)

| Event | Trigger | Notable Properties |
| --- | --- | --- |
| `screen_view` | Primary UI surface changes via `trackScreenView`. | `screen_name` (`gallery`, `player`, `editor`), optional `previous_view`, `trigger`. |
| `viewer_transcode_failed` | Playback fallback cannot establish an HLS session. | `error_message`, video metrics from `getVideoAnalyticsProps`. |
| `viewer_video_opened` | User opens the inline video viewer. | Video metrics from `getVideoAnalyticsProps`, `trigger`. |
| `viewer_video_closed` | Viewer closes and playback session is torn down. | Video metrics, `trigger`, `previous_view`. |
| `editor_opened` | Editor modal is launched. | `trigger`, `previous_view`. |
| `search_applied` | Library search is executed. | `query_length`, `result_count`, `filter_count` (see implementation). |
| `video_renamed` | Library rename succeeds. | Video metrics, `name_length`, `extension_changed`. |
| `video_deleted` | File deletion workflow completes. | Video metrics, `permanent` flag. |
| `settings_directory_added` | User adds a monitored directory. | Directory summary (`directory_depth`, `has_spaces`, `is_network_path`), `directory_label_length`, `total_directories`. |
| `settings_directory_removed` | Directory removed from monitoring list. | Directory summary metrics. |
| `settings_directory_add_skipped` | Add-directory dialog dismissed because the path already exists. | Directory summary, `reason` (`duplicate`). |
| `settings_saved` | Settings modal saved successfully. | `directory_count`, `youtube_connected`, `analytics_opted_in`. |
| `youtube_auth_flow_started` | User initiates OAuth flow. | `has_existing_account`, `trigger`. |
| `youtube_auth_flow_triggered` | OAuth window successfully opened. | `provider`. |
| `youtube_auth_flow_failed` | OAuth launch fails. | `error_message`. |
| `youtube_auth_authenticated` | OAuth callback succeeds. | `account_id_present`, `channel_title_present`. |
| `youtube_auth_disconnected` | Account is disconnected by the user. | `account_id_present`. |
| `youtube_auth_signed_out` | Sign-out completes after token revocation. | `account_id_present`. |
| `youtube_account_selected` | User switches between linked YouTube accounts. | `account_id_present`. |
| `youtube_account_select_failed` | Switching active account fails. | `error_message`. |
| `youtube_account_removed` | Linked account removed successfully. | `account_id_present`. |
| `youtube_account_remove_failed` | Account removal fails. | `error_message`. |
| `youtube_upload_started` | Upload flow submitted in “upload” mode. | `mode`, `privacy`, `title_length`, `has_description`. |
| `youtube_upload_queued` | Upload job enqueued by the main process. | Same as above plus `has_job`. |
| `youtube_upload_failed` | Upload start fails. | `error_message`, submission metadata. |
| `youtube_metadata_update_started` | Upload dialog submitted in “update metadata” mode. | Submission metadata. |
| `youtube_metadata_updated` | Metadata update completes. | Submission metadata. |
| `youtube_metadata_update_failed` | Metadata update fails. | `error_message`, submission metadata. |
| `youtube_video_removed` | YouTube deletion succeeds. | Video metrics. |
| `youtube_video_remove_failed` | YouTube deletion fails. | Video metrics, `error_message`. |

## Main Process (Electron)

| Event | Trigger | Notable Properties |
| --- | --- | --- |
| `application_start` | Emitted once the main process has loaded the registry and IPC handlers. | `app_version`, `platform`, `platform_release`. |
| `event_schema_download_failed` | Remote registry fetch fails (first boot or scheduled refresh). | `reason`, `attempt`, `status_code`. |
| `event_schema_download_success` | Remote registry fetch returns a new version and is applied. | `attempt`, `elapsed_ms`. |
| `directory_watch_started` | Directory watcher boots with at least one monitored folder. | `directory_count`, `network_path_count`, `has_custom_labels`. |
| `directory_watch_stopped` | Watchers stop during shutdown. | Same directory summary as above. |
| `transcoder_started` | Embedded transcoder service successfully starts. | `port`. |
| `transcoder_start_failed` | Transcoder fails to start on app launch. | `error_message`. |
| `transcoder_stop_requested` | App initiates transcoder shutdown during quit. | `port`. |
| `transcoder_stopped` | Transcoder stops cleanly. | `port`. |
| `transcoder_stop_failed` | Transcoder fails to stop gracefully. | `error_message`, `port`. |
| `youtube_records_loaded` | Cached YouTube data loads on startup. | `success`, optional `error_message`. |
| `app_will_quit` | Electron `will-quit` lifecycle fires. | `platform`. |

## Transcoder Service

| Event | Trigger | Notable Properties |
| --- | --- | --- |
| `transcoder_server_started` | Express server binds successfully. | `port`. |
| `transcoder_server_error` | Express server fails to start. | `port`, `error_message`. |
| `transcoder_server_stopped` | Express server shuts down. | None beyond `active_session_count`. |
| `transcoder_session_created` | New HLS session record created. | `session_id`, `file_extension`. |
| `transcoder_session_ready` | HLS manifest available for playback. | `session_id`, `time_to_ready_ms`. |
| `transcoder_session_reused` | Existing session reused for the same source. | `session_id`, `file_extension`. |
| `transcoder_session_force_recycled` | Stale session forcefully torn down and recreated. | `session_id`, `reason`. |
| `transcoder_session_failed` | Session setup fails. | `session_id`, `error_message`. |
| `transcoder_session_destroyed` | Session cleanup completes. | `session_id`, `age_ms`. |
| `transcoder_session_deleted` | DELETE request for a session succeeds. | `session_id`. |
| `transcoder_session_delete_failed` | DELETE request for a session fails. | `session_id`, `error_message`. |
| `transcoder_session_issued` | Playback request returns session metadata. | `session_id`, `file_extension`. |
| `transcoder_session_request_failed` | Playback request fails before issuing a session. | `error_message`. |
| `transcoder_sessions_cleaned` | Periodic cleanup removes expired sessions. | `expired_count`. |

